package com.agilex.healthcare.veteranappointment.datalayer.patient;

import com.agilex.healthcare.veteranappointment.datalayer.AbstractDao;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.NoResultException;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.Map;

@Repository
public class NotificationPreferenceDao extends AbstractDao {
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(NotificationPreferenceDao.class);

    public NotificationPreferencePo get(String patientId) {
        if (logger.isDebugEnabled()) logger.debug("Retrieving Notification Preferences");

        Query query = this.constructFetchQuery(patientId);      
        
        NotificationPreferencePo notificationPreference = new NotificationPreferencePo();
		try {
			notificationPreference = (NotificationPreferencePo) query.getSingleResult();
		} catch (NoResultException e) {
			logger.debug(e);
		}        
        return notificationPreference;
    }
    
    @Transactional(propagation = Propagation.REQUIRED)
    public NotificationPreferencePo update(VARPatientPreference patientPreference){
    	if (logger.isDebugEnabled()) logger.debug("Creating Notification Preference entry");
    	
    	NotificationPreferencePo notificationPreference = entityManager.merge(new NotificationPreferencePo(patientPreference));
    	return notificationPreference;
    }
    
    @Transactional(propagation = Propagation.REQUIRED)
    public void delete(VARPatientPreference patientPreference){
    	if (logger.isDebugEnabled()) logger.debug("Deleting Notification Preference entry");
    	    	
    	Query query = this.constructDeleteQuery(patientPreference.getPatientId()); 
    	query.executeUpdate();
    }
    
    public Query constructFetchQuery(String patientId){
    	Map<String, Object> parameters = new HashMap<String, Object>();
    	
    	String query = "from NotificationPreferencePo a where a.patientId =:patientId ";   
    	
    	setPatientIdParameter(patientId, parameters);
    	Query constructedQuery = this.setQueryParameters(query,parameters);
    	return constructedQuery;
    }    
    
    public void setPatientIdParameter(String patientId, Map<String, Object> parameters){
    	parameters.put("patientId", patientId);
    }
    public Query setQueryParameters(String query, Map<String, Object> parameters){
    	Query constructedQuery = this.entityManager.createQuery(query);
    	for(String key : parameters.keySet()){
    		constructedQuery.setParameter(key, parameters.get(key));
    	}
    	return constructedQuery;
    }
    
    public Query constructDeleteQuery(String patientId){
    	Map<String, Object> parameters = new HashMap<String, Object>();
    	
    	String query = "DELETE from NotificationPreferencePo a where a.patientId =:patientId ";   
    	
    	setPatientIdParameter(patientId, parameters);
    	Query constructedQuery = this.setQueryParameters(query,parameters);
    	return constructedQuery;
    }
}
